
import {NewProvisioningProfileDto, ProvisioningProfileClient, ProvisioningProfilesFilter} from "../clients/metaApi/provisioningProfile.client";
import ProvisioningProfile from "./provisioningProfile";

/**
 * Exposes provisioning profile API logic to the consumers
 */
export default class ProvisioningProfileApi {

  /**
   * Constructs a provisioning profile API instance
   * @param {ProvisioningProfileClient} provisioningProfileClient provisioning profile REST API client
   */
  constructor(provisioningProfileClient: ProvisioningProfileClient);

  /**
   * Retrieves provisioning profiles, provides pagination in infinite scroll style
   * @param {ProvisioningProfilesFilter} [filter] provisioning profiles filter
   * @return {Promise<Array<ProvisioningProfile>>} promise resolving with an array of provisioning profile entities
   */
  getProvisioningProfilesWithInfiniteScrollPagination(filter?: ProvisioningProfilesFilter): Promise<Array<ProvisioningProfile>>;

  /**
   * Retrieves provisioning profiles and count, provides pagination in a classic style
   * @param {ProvisioningProfilesFilter} [filter] provisioning profiles filter
   * @return {Promise<ProvisioningProfilesList>} promise resolving with provisioning profile entities and count
   */
  getProvisioningProfilesWithClassicPagination(filter?: ProvisioningProfilesFilter): Promise<ProvisioningProfilesList>;

  /**
   * Retrieves a provisioning profile by id
   * @param {string} provisioningProfileId provisioning profile id
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */
  getProvisioningProfile(provisioningProfileId: string): Promise<ProvisioningProfile>;

  /**
   * Creates a provisioning profile
   * @param {NewProvisioningProfileDto} profile provisioning profile data
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */
  createProvisioningProfile(profile: NewProvisioningProfileDto): Promise<ProvisioningProfile>;
}

/**
 * Provisioning profile list entity
 */
declare type ProvisioningProfilesList = {

  /**
   * provisioning profiles count
   */
  count: number,

  /**
   * provisioning profile entities list
   */
  items: Array<ProvisioningProfile>,
}