'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import ProvisioningProfile from './provisioningProfile';
import { ProvisioningProfilesList } from './provisioningProfileApi';
let ProvisioningProfileApi = class ProvisioningProfileApi {
    /**
   * Retrieves provisioning profiles, provides pagination in infinite scroll style
   * @param {ProvisioningProfilesFilter} [filter] provisioning profiles filter
   * @return {Promise<Array<ProvisioningProfile>>} promise resolving with an 
   * array of provisioning profile entities
   */ getProvisioningProfilesWithInfiniteScrollPagination(filter) {
        var _this = this;
        return _async_to_generator(function*() {
            let profiles = yield _this._provisioningProfileClient.getProvisioningProfiles(filter, '1');
            return profiles.map((p)=>new ProvisioningProfile(p, _this._provisioningProfileClient));
        })();
    }
    /**
   * Retrieves provisioning profiles and count, provides pagination in a classic style
   * @param {ProvisioningProfilesFilter} [filter] provisioning profiles filter
   * @return {Promise<ProvisioningProfilesList>} promise resolving with provisioning profile entities and count
   */ getProvisioningProfilesWithClassicPagination(filter) {
        var _this = this;
        return _async_to_generator(function*() {
            let profiles = yield _this._provisioningProfileClient.getProvisioningProfiles(filter, '2');
            return {
                count: profiles.count,
                items: profiles.items.map((p)=>new ProvisioningProfile(p, _this._provisioningProfileClient))
            };
        })();
    }
    /**
   * Retrieves a provisioning profile by id
   * @param {String} provisioningProfileId provisioning profile id
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */ getProvisioningProfile(provisioningProfileId) {
        var _this = this;
        return _async_to_generator(function*() {
            let profile = yield _this._provisioningProfileClient.getProvisioningProfile(provisioningProfileId);
            return new ProvisioningProfile(profile, _this._provisioningProfileClient);
        })();
    }
    /**
   * Creates a provisioning profile
   * @param {NewProvisioningProfileDto} profile provisioning profile data
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */ createProvisioningProfile(profile) {
        var _this = this;
        return _async_to_generator(function*() {
            let id = yield _this._provisioningProfileClient.createProvisioningProfile(profile);
            return new ProvisioningProfile(Object.assign({}, profile, {
                _id: id.id,
                status: 'new'
            }), _this._provisioningProfileClient);
        })();
    }
    /**
   * Constructs a provisioning profile API instance
   * @param {ProvisioningProfileClient} provisioningProfileClient provisioning profile REST API client
   */ constructor(provisioningProfileClient){
        this._provisioningProfileClient = provisioningProfileClient;
    }
};
/**
 * Exposes provisioning profile API logic to the consumers
 */ export { ProvisioningProfileApi as default };

//# sourceMappingURL=data:application/json;base64,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