import DomainClient from './domain.client';
/**
 * metaapi.cloud MetaTrader API client
 */
export default class MetaApiClient {
    protected _domainClient: DomainClient;
    protected _token: any;
    /**
     * Constructs MetaTrader API client instance
     * @param {DomainClient} domainClient domain client
     */
    constructor(domainClient: DomainClient);
    /**
     * Returns type of current token
     * @returns {string} Type of current token
     * @protected
     */
    protected get _tokenType(): "" | "api" | "account";
    /**
     * Checks that current token is not api token
     * @returns {boolean} Indicator of absence api token
     * @protected
     */
    protected _isNotJwtToken(): boolean;
    /**
     * Checks that current token is not account token
     * @returns {boolean} Indicator of absence account token
     * @protected
     */
    protected _isNotAccountToken(): boolean;
    /**
     * Handles no accessing to the method
     * @param {string} methodName Name of method
     * @protected
     * @throws
     */
    protected _handleNoAccessError(methodName: any): Promise<never>;
}
